import sys
import math

def resi_zadatak():
    """
    Funkcija koja cita ulazne podatke sa standarnog ulaza (konzole),
    obradjuje ih prema pravilima zadatka i ispisuje rezultat.
    """
    try:
        # Citanje svih brojeva sa standarnog ulaza odjednom
        # Ovo resava problem unosa koji se proteze kroz više redova
        svi_brojevi = list(map(int, sys.stdin.read().strip.split()))

        if not svi_brojevi:
            return

        # Prvi brojje N (broj svaki)
        N = svi_brojevi
        # K (drugi broj) se ne koristi u proracunu, ali je deo ulaza
        cene = svi_brojevi[2:] # Stvarne cene pocinju od treceg broja

        original_sum = 0
        rounded_sum = 0

        # Pronalazak kroz pravih N cena
        for i in range(N):
            if i >= len(cene):
                break
            cena = cene[i]
            original_sum += cena

            # Logika zaokruzivanja na najblizu stotinu (npr. 183 -> 200, 14 -> 0, 250 -> 300)
            zaokruzena_cena = round(cena / 100) * 100
            rounded_sum += zaokruzena_cena


        # Izracunavanje apsolutne razlike izmedju originalne i zaokruzene sume
        razlika = abs(original_sum - rounded_sum)

        # Ispis rezultata sa standardni izlaz, svaki u posebnom redu
        print(rounded_sum)
        print(razlika)

    except ValueError:
        pass
    except IndexError:
        pass
    # --- Glavni deo programa i resenja primera ---

    if _name_ == "_main_":

        # resi_zadatak() # <--- Otkomenatrisite ovu liniju na citanje sa standardnog ulaza

        # Resenje za Primer 1:
        # Ulaz: 7 10000000000 \n 183 14 250 995 300 10 72
        # Ocekuje se ispis:
        # 1900
        # 76

        # Resenje za Primer 2:
        # Ulaz: 2 \n 250 995
        # Ocekuje se ispis:
        # 1300
        # 55
        pass